/**
 * ShortURL WordPress Plugin Admin JavaScript
 */

(function($) {
    'use strict';

    // Quick create form
    $('#shorturl-quick-create').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $result = $('#shorturl-result');
        var $button = $form.find('button');
        
        $button.prop('disabled', true).text('Creating...');
        
        $.ajax({
            url: shorturl_ajax.url,
            type: 'POST',
            data: {
                action: 'shorturl_create',
                nonce: shorturl_ajax.nonce,
                url: $form.find('input[name="url"]').val(),
                title: $form.find('input[name="title"]').val()
            },
            success: function(response) {
                if (response.success) {
                    $result.removeClass('error').addClass('show').html(
                        '<p>Short URL created successfully!</p>' +
                        '<p class="short-url">' + response.data.short_url + '</p>' +
                        '<p><button type="button" class="button copy-url" data-url="' + response.data.short_url + '">Copy to Clipboard</button></p>'
                    );
                    $form[0].reset();
                } else {
                    $result.addClass('error show').html('<p>Error: ' + response.data.message + '</p>');
                }
            },
            error: function() {
                $result.addClass('error show').html('<p>Error connecting to API</p>');
            },
            complete: function() {
                $button.prop('disabled', false).text('Shorten');
            }
        });
    });

    // Full create form
    $('#shorturl-create-form').on('submit', function(e) {
        e.preventDefault();
        
        var $form = $(this);
        var $result = $('#shorturl-create-result');
        var $button = $form.find('button[type="submit"]');
        
        $button.prop('disabled', true).text('Creating...');
        
        $.ajax({
            url: shorturl_ajax.url,
            type: 'POST',
            data: {
                action: 'shorturl_create',
                nonce: shorturl_ajax.nonce,
                url: $form.find('input[name="url"]').val(),
                title: $form.find('input[name="title"]').val(),
                custom_alias: $form.find('input[name="custom_alias"]').val()
            },
            success: function(response) {
                if (response.success) {
                    $result.html(
                        '<div class="success-box">' +
                        '<h3>✓ Short URL Created!</h3>' +
                        '<p class="short-url">' + response.data.short_url + '</p>' +
                        '<p><button type="button" class="button button-primary copy-url" data-url="' + response.data.short_url + '">Copy to Clipboard</button></p>' +
                        '</div>'
                    );
                    $form[0].reset();
                } else {
                    $result.html('<div class="notice notice-error"><p>' + response.data.message + '</p></div>');
                }
            },
            error: function() {
                $result.html('<div class="notice notice-error"><p>Error connecting to API</p></div>');
            },
            complete: function() {
                $button.prop('disabled', false).text('Create Short Link');
            }
        });
    });

    // Copy to clipboard
    $(document).on('click', '.copy-url, .shorturl-copy-btn', function() {
        var url = $(this).data('url');
        
        if (navigator.clipboard) {
            navigator.clipboard.writeText(url).then(function() {
                alert('Copied to clipboard!');
            });
        } else {
            var $temp = $('<input>');
            $('body').append($temp);
            $temp.val(url).select();
            document.execCommand('copy');
            $temp.remove();
            alert('Copied to clipboard!');
        }
    });

    // Create short URL for post
    $(document).on('click', '.shorturl-create-for-post', function() {
        var $button = $(this);
        var url = $button.data('url');
        var postId = $button.data('post-id');
        
        $button.prop('disabled', true).text('Creating...');
        
        $.ajax({
            url: shorturl_ajax.url,
            type: 'POST',
            data: {
                action: 'shorturl_create',
                nonce: shorturl_ajax.nonce,
                url: url,
                post_id: postId
            },
            success: function(response) {
                if (response.success) {
                    $button.closest('.shorturl-meta-box').html(
                        '<p><strong>Short URL:</strong></p>' +
                        '<input type="text" value="' + response.data.short_url + '" readonly class="widefat" onclick="this.select();">' +
                        '<p><button type="button" class="button shorturl-copy-btn" data-url="' + response.data.short_url + '">Copy</button></p>'
                    );
                } else {
                    alert('Error: ' + response.data.message);
                    $button.prop('disabled', false).text('Generate Short URL');
                }
            },
            error: function() {
                alert('Error connecting to API');
                $button.prop('disabled', false).text('Generate Short URL');
            }
        });
    });

    // Test connection
    $('#shorturl-test-connection').on('click', function() {
        var $button = $(this);
        var $result = $('#shorturl-test-result');
        
        $button.prop('disabled', true);
        $result.removeClass('success error').text('Testing...');
        
        $.ajax({
            url: shorturl_ajax.url,
            type: 'POST',
            data: {
                action: 'shorturl_get_stats',
                nonce: shorturl_ajax.nonce
            },
            success: function(response) {
                if (response.success) {
                    $result.addClass('success').text('✓ Connected successfully!');
                } else {
                    $result.addClass('error').text('✗ ' + response.data.message);
                }
            },
            error: function() {
                $result.addClass('error').text('✗ Connection failed');
            },
            complete: function() {
                $button.prop('disabled', false);
            }
        });
    });

})(jQuery);
