/**
 * ShortURL Browser Extension - Options Page Script
 */

const DEFAULT_API_URL = 'http://localhost/shorturl/api/v1';

document.addEventListener('DOMContentLoaded', async () => {
  const form = document.getElementById('settingsForm');
  const apiUrlInput = document.getElementById('apiUrl');
  const apiKeyInput = document.getElementById('apiKey');
  const success = document.getElementById('success');
  
  // Load saved settings
  const settings = await chrome.storage.sync.get(['apiUrl', 'apiKey']);
  apiUrlInput.value = settings.apiUrl || DEFAULT_API_URL;
  apiKeyInput.value = settings.apiKey || '';
  
  // Handle form submission
  form.addEventListener('submit', async (e) => {
    e.preventDefault();
    
    const apiUrl = apiUrlInput.value.trim() || DEFAULT_API_URL;
    const apiKey = apiKeyInput.value.trim();
    
    await chrome.storage.sync.set({ apiUrl, apiKey });
    
    success.style.display = 'block';
    setTimeout(() => {
      success.style.display = 'none';
    }, 3000);
  });
});
