# ShortURL Browser Extension

A browser extension for Chrome, Firefox, and Edge to quickly shorten URLs.

## Features

- One-click URL shortening from the toolbar
- Right-click context menu to shorten links
- Custom alias support
- Quick stats overview
- Copy to clipboard
- Works with your self-hosted ShortURL instance

## Installation

### Chrome / Edge

1. Open `chrome://extensions/` (or `edge://extensions/`)
2. Enable "Developer mode"
3. Click "Load unpacked"
4. Select the `browser-extension` folder

### Firefox

1. Open `about:debugging#/runtime/this-firefox`
2. Click "Load Temporary Add-on"
3. Select `manifest.json` from the `browser-extension` folder

## Configuration

1. Click the extension icon
2. Click "Settings" or right-click and select "Options"
3. Enter your ShortURL API URL (e.g., `https://your-domain.com/api/v1`)
4. Enter your API key (found in Dashboard → Settings → API)
5. Click "Save Settings"

## Usage

### Popup

1. Click the extension icon
2. The current page URL is auto-filled
3. Optionally add a custom alias
4. Click "Shorten URL"
5. Copy or open the shortened link

### Context Menu

1. Right-click on any link or page
2. Select "Shorten this link with ShortURL" or "Shorten current page"
3. The short URL is automatically copied to clipboard

## Building for Production

### Chrome Web Store

1. Zip the extension folder
2. Upload to [Chrome Developer Dashboard](https://chrome.google.com/webstore/devconsole)

### Firefox Add-ons

1. Run `web-ext build` in the extension folder
2. Upload to [Firefox Add-on Developer Hub](https://addons.mozilla.org/developers/)

## Files

- `manifest.json` - Extension configuration
- `popup.html/js` - Toolbar popup UI
- `options.html/js` - Settings page
- `background.js` - Background service worker
- `icons/` - Extension icons (16, 32, 48, 128px)

## Icons

You need to create icon files in the `icons/` folder:

- `icon16.png` (16x16)
- `icon32.png` (32x32)
- `icon48.png` (48x48)
- `icon128.png` (128x128)

Use your ShortURL logo or create a simple link icon.
